<?php

namespace App\Http\Middleware;

use App\Contracts\Security\EncryptDecryptInterface;
use App\Contracts\Security\SessionInterface;
use App\Contracts\Security\TokenRandomGenerateInterface;
use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;
use App\Contracts\Repository\UserLearnboxInterface;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Route;
class ValidateInitialToken
{
    public function __construct(
        SessionsBetweenVersionsInterface $sessionsBetweenVersionsInterface,
        EncryptDecryptInterface $encryptDecryptInterface,
        SessionInterface $sessionInterface,
        TokenRandomGenerateInterface $tokenRandomGenerateInterface,
        UserLearnboxInterface $userLearnboxInterface
    )
    {
        $this->sessionsBetweenVersionsInterface = $sessionsBetweenVersionsInterface;
        $this->encryptDecryptInterface = $encryptDecryptInterface;
        $this->sessionInterface = $sessionInterface;
        $this->tokenRandomGenerateInterface = $tokenRandomGenerateInterface;
        $this->userLearnboxInterface = $userLearnboxInterface;
    }

    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if($request->token) {
            $dataJson = $this->encryptDecryptInterface->decryptData($request->token, Config::get("constants.key_encrypt_methods"));
        }
        if(isset($request->petition) && isset($request->current_uri)){
            $currentUri=urldecode($request->current_uri);
            $dataJson = $this->encryptDecryptInterface->decryptData($request->petition, Config::get("constants.key_encrypt_methods"));
            if(json_decode($dataJson)->permission=='SESSION_AVAILABLE'){
                $request->session()->put('token_validity', date("Y-m-d h:i:s"));
                return redirect($currentUri);
            }else{
                $request->session()->forget('current_serial_usr');
                $request->session()->forget('current_serial_prf');
                $request->session()->forget('current_serial_prc');
                $request->session()->forget('life_token');
                $request->session()->forget('token_validity');
                $request->session()->forget('type_usr');
                $request->session()->forget('serial_grd');
                $request->session()->forget('serial_emp');
                $request->session()->forget('serial_std');
                return abort(404);
            }
        }

        $url = (isset($request->url) && $request->url != '') ? $request->url : false;
        $data = isset($dataJson)?json_decode($dataJson):NULL;

        if (isset($data->initial_token) && isset($data->serial_usr) && isset($data->menu_prc) && isset($data->serial_prf) && isset($request->url)) {
            //token desde version 5.4
            $initialToken = $data->initial_token;
            $serialUsr = $data->serial_usr;
            $serialPrc = $data->menu_prc;
            $serialPrf = $data->serial_prf;
            //datos de usuario
            $userData=$this->userLearnboxInterface->getUserDataBySerialUsr($data->serial_usr);
            $initialTokenSaved = $this->sessionsBetweenVersionsInterface->getInitialToken($serialUsr, $initialToken);
            if ($initialTokenSaved) {
                $lifeToken = $this->tokenRandomGenerateInterface->generateToken('life_token', ['serial_usr' => $serialUsr]);
                $resultUpdate = $this->sessionsBetweenVersionsInterface->updateLifeToken($serialUsr, $initialTokenSaved->initial_token_sbv, $lifeToken,false);
                $request->session()->put('current_serial_usr', $serialUsr);
                $request->session()->put('type_usr',   $userData->type_user);
                $request->session()->put('serial_grd', $userData->serial_grd);
                $request->session()->put('serial_emp', $userData->serial_emp);
                $request->session()->put('serial_std', $userData->serial_std);
                $request->session()->put('current_serial_prf', $serialPrf);
                $request->session()->put('current_serial_prc', $serialPrc);
                $request->session()->put('life_token', $lifeToken);
                $request->session()->put('token_validity', date("Y-m-d h:i:s"));
                return redirect($url);
            }
        }

        if ($request->session()->has('current_serial_usr') && $request->session()->has('life_token') && $request->session()->has('token_validity')) {
            $time=(strtotime(date("Y-m-d h:i:s"))-strtotime($request->session()->get('token_validity')))/60;
            $tokenEncrypt=$this->encryptDecryptInterface->encryptData($request->session()->get('life_token'), Config::get("constants.key_encrypt_methods"));
            if($time>1){
                return redirect(env('LEARNBOX_OLD_VERSION').'laravel/public/validateSession/index?serial_usr='.$request->session()->get('current_serial_usr').'&serial_prf='.$request->session()->get('current_serial_prf').'&current_uri='.Route::currentRouteName().'&token='.$tokenEncrypt);
            }else{
                return $next($request);
            }
        }
        return redirect(env('LEARNBOX_OLD_VERSION'));
        return abort(404);
    }
}
