<?php

namespace App\Http\Middleware;

use App\Contracts\MenuServiceInterface;
use App\Contracts\Security\VerifyAllowedPagesProcessInterface;
use App\Repository\ProcessRepository;
use Closure;
use Illuminate\Http\Request;
use Illuminate\View\View;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Route;

class PermissionMiddleware
{
    /**
     * @param MenuServiceInterface $menuService -> app/Service/MenuService.php
     * @param VerifyAllowedPagesProcessInterface $verifyAllowedPagesProcess -> app/Service/Security/VerifyAllowedPagesProcessService.php
     * @return view
     * @author Diego Navarrete
     * @date 2024-01-13
     * @provider ServicesRutatecServiceProvider
     */
    public function __construct(ProcessRepository $processRepository, VerifyAllowedPagesProcessInterface $verifyAllowedPagesProcess)
    {
        $this->processRepository = $processRepository;
        $this->verifyAllowedPagesProcess = $verifyAllowedPagesProcess;
    }

    /**
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @author Diego Navarrete <donavarrete@rutatec.com/>
     * @date 2024-01-13
     * @description middleware para revisar los permisos de los metodos
     */
    public function handle(Request $request, Closure $next): Response
    {
        $action = Route::getCurrentRoute()->getAction();
        $controller_action = strtolower($action['controller']);

        //Obtenemos el perfil actual
        $serialPrf = '';
        if ($request->session()->get('current_serial_prf')) {
            $serialPrf = $request->session()->get('current_serial_prf');
        }
        $access = $this->processRepository->menuOld($serialPrf);
        $concedido = false;
        $serial_prc = '';

        for ($i = 0; $i < count($access); $i++) {
            //verificamos si proceso tiene acceso al controlador ya accion actual
            $concedido = $this->verifyAllowedPagesProcess->verify($access [$i] ->serial_prc, $controller_action);
            if ($concedido) {
                if (isset($_SESSION['alternative_rutademic_serial_usr'])) {
                    $obj = new LogAlternativeSession();
                    $obj->serial_real_usr = $_SESSION['alternative_rutademic_serial_usr']['serial_usr'];
                    $obj->serial_alternative_usr = $_SESSION['rutademic_serial_usr']['serial_usr'];
                    $obj->serial_real_prf = $_SESSION['alternative_rutademic_serial_usr']['profiles'][0]['serial_prf'];
                    $obj->serial_alternative_prf = $_SESSION['rutademic_serial_usr']['profiles'][0]['serial_prf'];
                    $obj->proccess_las = $controller_action;
                    $obj->data_send_las = NULL;
                    $obj->save();
                }

                //Si se cumple una vez salimos del for
                break;
            }

        }

        //dd($concedido);
        //Verificamos si en el recorrido del for no se encontro los permisos necesitados
        if (!$concedido) {
            abort(403, 'Se ha denegado el permiso a esta pagina!');
        }else{
            return $next($request);
        }
        //dd($access);
        //return $next($request);
    }
}
