<?php

namespace App\Http\Controllers\Teacher;


use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use Illuminate\Routing\Controller;
use Illuminate\Http\Request;

class TeacherGradeEntryController extends Controller
{
    /**
 * @author Diego Navarrete
 * @date 2023-11-19
 * @provider SubjectsServiceProvider
 *
 * @param SubjectsInYearByUserInterface $subjectsInYearByUserInterface -> app/Service/Subjects/SubjectsUserYearService.php
 * @return view
 */
    public function __construct( SubjectsInYearByUserInterface $subjectsInYearByUserInterface)
    {
        $this->subjectsInYearByUserInterface=$subjectsInYearByUserInterface;
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-19
     * @description metodo que regresa el index de las calificaciones del profesor
     * @param Request $request
     * @return view
     */
    public function getIndex(Request $request){
        return view('teacherGradeEntry.index', array());
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-22
     * @description metodo que regresa el contenido del nav escogido
     * @param Request $request
     * @return view
     */
    public function postContentNav(){
        $idnav=$_POST['idnav'];
        if(isset($idnav)){
            switch ($idnav){
                case "calendarNav":
                    return view('teacherGradeEntry.load.calendarNav', array());
                    break;
                case "activityNav":

                    break;
                case "testNav":
                    break;
                case "testNav":
                    break;
                case "skillsNav":
                    break;
                case "statisticNav":
                    return $this->statistics();
                    break;
                default:
                    break;

            }
        }
    }

    function statistics(){

        $serialScy=5;
        $serialTypeUser=621;
        $serialTypeUser=527;
        $subjects=$this->subjectsInYearByUserInterface->subjects($serialScy,$serialTypeUser,'teacher');
        return view('teacherGradeEntry.load.statisticsNav', array('subjects'=>$subjects));
    }
}
