<?php

namespace App\Http\Controllers\Teacher;
use App\Contracts\Repository\SubperiodAverageSubjectInterface;
use App\Contracts\Service\Average\SubperiodAverageServiceInterface;
use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class StatisticTeacherController extends Controller
{


    /**
     * @param SubjectsInYearByUserInterface $subjectsInYearByUserInterface -> app/Service/Subjects/SubjectsUserYearService.php
     * @param SubperiodAverageSubjectInterface $subperiodAverageSubjectInterface -> app/Service/Average/SubperiodAverageService.php
     * @return view
     * @author Diego Navarrete
     * @date 2023-11-25
     * @provider SubjectsServiceProvider
     *
     */
    public function __construct(SubjectsInYearByUserInterface $subjectsInYearByUserInterface,SubperiodAverageServiceInterface $subperiodAverageServiceInterface)
    {
        //$this->middleware('permission.learnbox');
        $this->subjectsInYearByUserInterface=$subjectsInYearByUserInterface;
        $this->subperiodAverageServiceInterface=$subperiodAverageServiceInterface;
    }

    /**
     * @param Request $request
     * @return view
     * @author Diego Navarrete
     * @date 2023-11-25
     * @description metodo que regresa el index del home teacher
     */
    public function getIndex(Request $request)
    {
        $serialScy = 5;
        $serialTypeUser = 621;
        $serialTypeUser = 527;
        $serialSbc=3260;
        $serialSbp=75;


        return view('statisticTeacher.index', array());
    }

    /**
     * @param DateDayInterface $dateDayService -> app/Service/Date/DateDayService.php
     * @return view
     * @author Diego Navarrete
     * @date 2023-11-16
     * @provider HomeServiceProvider
     */
    public function postScheduleTeacher()
    {
        $input = $_POST;
        $serialTypeUser = 621;
        $serialTypeUser = 527;
        $serialScy = 5;
        if (isset($input['day'])) {
            $today = $input['day'];
        } else {
            $today = $this->dateDayService->dateDay('TODAY');
            $today = isset($today->day_ddc) ? $today->day_ddc : 'MONDAY';
        }
        $subjectsSchedule = $this->subjectsScheduleByUserAndDayService->getSubjectsScheduleByUserAndDay($serialTypeUser, $serialScy, $today, 'TEACHER');
        return view('homeTeacher.loads.scheduleTeacher', array(
            'subjectsSchedule' => $subjectsSchedule,
            'today' => $today,
        ));
    }


    /**
     * @author Diego Navarrete
     * @date 2023-11-26
     * @description metodo que regresa el contenido del nav escogido
     * @param Request $request
     * @return view
     */
    public function postContentNav(){
        $idnav=$_POST['idnav'];
        if(isset($idnav)){
            switch ($idnav){
                case "courseNav":
                    return $this->statisticCourse();
                    break;
                case "subjectNav":
                    return $this->statisticSubject();
                    break;
                case "testNav":
                    break;
                case "testNav":
                    break;
                case "skillsNav":
                    break;
                case "statisticNav":
                    break;
                default:
                    break;

            }
        }
    }

    function statisticSubject(){
        $serialScy = 5;
        $serialTypeUser = 621;
        $serialTypeUser = 527;
        $serialSbc=3260;
        $serialSbp=75;
        $subjects=$this->subjectsInYearByUserInterface->subjects($serialScy,$serialTypeUser,'teacher');
        //$average=$this->subperiodAverageServiceInterface->getAverage($serialSbp,$serialSbc,'ACTIVE','ALL','MANDATORY',false,'MANDATORY_ALL_STUDENTS');
        $auxAverage=array();
        //armo arreglo con promedios por materias
        foreach ($subjects as $itemSbj){
            $arrayItemData=array();
            $auxTotalGrades=0;
            $auxTotalAvg=0;
            //dd($itemSbj);
            $arrayItemData['name_csb']       = ($itemSbj->short_name_csb && $itemSbj->short_name_csb!='')?$itemSbj->short_name_csb:$itemSbj->name_csb;
            $arrayItemData['name_crs']       = $itemSbj->name_crs;
            $arrayItemData['type_subject']   = $itemSbj->type_subject;
            $arrayItemData['alter_name_lvl'] = $itemSbj->alter_name_lvl;
            $arrayItemData['name_clg'] = $itemSbj->name_clg;
            $average = $this->subperiodAverageServiceInterface->getAverage($serialSbp,$itemSbj->serial_sbc,'ACTIVE','ALL','MANDATORY',false,'MANDATORY_ALL_STUDENTS');
            if(count($average)>0){
                foreach ($average as $itemAvg){
                    if($itemAvg->average_sss !== NULL){
                        $auxTotalGrades++;
                        $auxTotalAvg=$auxTotalAvg+$itemAvg->average_sss;
                    }
                }
                $arrayItemData['average_sbc']=$auxTotalAvg/$auxTotalGrades;
            }else{
                $arrayItemData['average_sbc']=0;
            }
            array_push($auxAverage,$arrayItemData);
        }
        return view('statisticTeacher.loads.statisticsSubjectNav', array('auxAverage'=>json_encode($auxAverage)));
    }
    function statisticCourse(){
        $serialScy = 5;
        $serialTypeUser = 621;
        $serialTypeUser = 527;
        $serialSbc=3260;
        $serialSbp=75;
        $subjects=$this->subjectsInYearByUserInterface->subjects($serialScy,$serialTypeUser,'teacher');
        //$average=$this->subperiodAverageServiceInterface->getAverage($serialSbp,$serialSbc,'ACTIVE','ALL','MANDATORY',false,'MANDATORY_ALL_STUDENTS');
        $auxAverage=array();
        $arrayCourse=array();
        //armo arreglo con cursos, dentro de los cuales se encuentran las materias que imparten con los promedios de cada materia
        if(count($subjects)>0){
            foreach ($subjects as $itemSbj){
                $nameCrs=($itemSbj->alter_name_lvl && $itemSbj->alter_name_lvl!="") ? $itemSbj->alter_name_lvl.' '.$itemSbj->name_clg:$itemSbj->name_crs;
                if(!array_key_exists($nameCrs,$arrayCourse)){
                    $arrayCourse[$nameCrs]=array();
                }
                $nameCsb=($itemSbj->short_name_csb && $itemSbj->short_name_csb !="")?$itemSbj->short_name_csb:$itemSbj->name_csb;
                if($itemSbj->type_subject=="Obligatoria"){
                    if(!in_array($nameCsb,$arrayCourse[$nameCrs]) ){
                        $average = $this->subperiodAverageServiceInterface->getAverage($serialSbp,$itemSbj->serial_sbc,'ACTIVE','ALL','MANDATORY',false,'MANDATORY_BY_SUBJECT');
                    }
                }else{
                       $average = $this->subperiodAverageServiceInterface->getAverage($serialSbp,$itemSbj->serial_sbc,'ACTIVE','ALL','OPTATIVE',false,'OPTATIVE_BY_SUBJECT');
                }
                $averageSubject=isset($average->subject_average)?$average->subject_average:NULL;
                array_push($arrayCourse[$nameCrs],array('subject'=>$nameCsb,'average'=>$averageSubject));


            }
        }
        $arrayMandatoryResult=array();
        //armo promedios por cursos recorriendo el arreglo armado anteriormente
        if(count($arrayCourse)>0){
            foreach ($arrayCourse as $key=>$itemC){
                $auxAverageSubject=0;
                $auxCountSubject=0;
                $arrayItemData=array();
                //for que recorra las materias
                foreach ($itemC as $itemSubj){
                    if($itemSubj['average'] != NULL){
                        $auxAverageSubject +=$itemSubj['average'];
                        $auxCountSubject++;
                    }
                }
                $averageCourse=($auxCountSubject>0)?$auxAverageSubject/$auxCountSubject:NULL;
                $arrayItemData['name_course']=$key;
                $arrayItemData['average_crs']=$averageCourse;
                array_push($arrayMandatoryResult,$arrayItemData);
            }
        }

        return view('statisticTeacher.loads.statisticsCourseNav', array('arrayMandatoryResult'=>json_encode($arrayMandatoryResult)));
    }
}
