<?php

namespace App\Http\Controllers\Teacher;

use App\Contracts\Service\Date\DateDayInterface;
use App\Contracts\Service\Flag\FlagConfiguredInterface;
use App\Contracts\Service\Subjects\SubjectsInYearByUserInterface;
use App\Service\Subjects\SubjectsScheduleByUserAndDayService;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class HomeTeacherController extends Controller
{

    /**
     * @author Diego Navarrete
     * @date 2023-11-11
     * @provider SubjectsServiceProvider
     *
     * @param SubjectsInYearByUserInterface $subjectsInYearByUserInterface -> app/Service/Subjects/SubjectsUserYearService.php
     * @param FlagConfiguredInterface $flagConfiguredInterface -> app/Service/flag/FlagConfiguredService.php
     * @param SubjectsScheduleByUserAndDayService $subjectsScheduleByUserAndDayService -> app/Service/Subjects/SubjectsScheduleByUserAndDayService.php
     * @param DateDayInterface $dateDayService -> app/Service/Date/DateDayService.php
     * @return view
     */
    public function __construct(
        SubjectsInYearByUserInterface $subjectsInYearByUserInterface,
        FlagConfiguredInterface $flagConfiguredInterface,
        SubjectsScheduleByUserAndDayService $subjectsScheduleByUserAndDayService,
        DateDayInterface $dateDayService
    )
    {
        $this->subjectsInYearByUserInterface=$subjectsInYearByUserInterface;
        $this->flagConfiguredInterface=$flagConfiguredInterface;
        $this->subjectsScheduleByUserAndDayService=$subjectsScheduleByUserAndDayService;
        $this->dateDayService=$dateDayService;
    }

    /**
     * @author Diego Navarrete
     * @date 2023-11-11
     * @description metodo que regresa el index del home teacher
     * @param Request $request
     * @return view
     */
    public function getIndex(Request $request){
        $serialScy= $request->session()->get('serial_scy')?$request->session()->get('serial_scy'):5;
        if($request->session()->get('serial_emp')){
            $serialTypeUser=$request->session()->get('serial_emp');

            $subjects=$this->subjectsInYearByUserInterface->subjects($serialScy,$serialTypeUser,'teacher');
            $flagUseNewHome=$this->flagConfiguredInterface->flagConfigured('SETUP','USE_NEW_HOME_TEACHER',false);
            //$subjectsSchedule=$this->subjectsScheduleByUserAndDayService->getSubjectsScheduleByUserAndDay($serialTypeUser,$serialScy,'MONDAY','TEACHER');
            return view('homeTeacher.index', array(
                'subjects'=>$subjects,
                'flagUseNewHome'=>$flagUseNewHome,
                //'subjectsSchedule'=>$subjectsSchedule,
            ));
        }

    }
    /**
     * @author Diego Navarrete
     * @date 2023-11-16
     * @provider HomeServiceProvider
     * @param DateDayInterface $dateDayService -> app/Service/Date/DateDayService.php
     * @return view
     */
    public function postScheduleTeacher(Request $request){
        $input=$_POST;
        $serialScy=$request->session()->get('serial_scy')?$request->session()->get('serial_scy'):5;
        if($request->session()->get('serial_emp')){
            $serialTypeUser=$request->session()->get('serial_emp');
        if(isset($input['today'])){
            $today=$input['today'];
        }else{
            $today=$this->dateDayService->dateDay('TODAY');
            $today=isset($today->day_ddc)?$today->day_ddc:'MONDAY';
        }
        $subjectsSchedule=$this->subjectsScheduleByUserAndDayService->getSubjectsScheduleByUserAndDay($serialTypeUser,$serialScy,$today,'TEACHER');
        return view('homeTeacher.loads.scheduleTeacher', array(
            'subjectsSchedule'=>$subjectsSchedule,
            'today'=>$today,
        ));
        }
    }
}
