<?php


namespace App\Classes\Token;


use App\Contracts\Security\LifeTokenInterface;
use App\Contracts\SessionsBetweenVersions\SessionsBetweenVersionsInterface;

class LifeToken implements LifeTokenInterface
{


    public function __construct(SessionsBetweenVersionsInterface $sessionsBetweenVersionsInterface)
    {
        $this->sessionsBetweenVersionsInterface=$sessionsBetweenVersionsInterface;
    }

    public function generateToken($serialUsr)
    {
        $lifeToken="";
        do {
            $lifeToken = bin2hex(openssl_random_pseudo_bytes(32));
            $existToken = $this->sessionsBetweenVersionsInterface->getLifeToken($serialUsr, $lifeToken);
        } while ($existToken);
        return $lifeToken;
    }


}
