<?php


namespace App\Classes;


use App\Contracts\Repository\ReadOnlyInterface;
use App\Contracts\SubMenuProfileInterface;
use App\Repository\ProcessRepository;
use App\Repository\SubProcessRepository;

class SubProcessUser implements SubMenuProfileInterface
{


    public function __construct(SubProcessRepository $subProcessRepository,ReadOnlyInterface $readOnly)
    {
        $this->subProcessRepository = $subProcessRepository;
        $this->readOnly = $readOnly;
    }

    public function submenu($serialPrf, $serialPrc)
    {
        $arrayObjectSubprocess = array();
        //Obtengo los submenus del proceso entrante
        $subprocessAux = $this->subProcessRepository->submenu($serialPrf, $serialPrc);

        if (count($subprocessAux) > 1) {
            foreach ($subprocessAux as $itemSub) {
                $arraySubprocess = array();
                if ($itemSub->link_prc == '#') {
                    $arraySubprocess['type_prc'] = 'PRINCIPAL';
                    $arraySubprocess['serial_prc'] = $itemSub->serial_prc;
                    $arraySubprocess['name_prc'] = $itemSub->name_prc;
                    $arraySubprocess["link"] = '#';
                    $arraySubprocess["submenu"] = $this->submenu($serialPrf, $itemSub->serial_prc);
                    if ($arraySubprocess["submenu"]!==false && count($arraySubprocess["submenu"]) > 0) {
                        array_push($arrayObjectSubprocess, $arraySubprocess);
                    }
                } else {
                    $arraySubprocess['type_prc'] = 'SECUNDARY';
                    $arraySubprocess['serial_prc'] = $itemSub->serial_prc;
                    $arraySubprocess['name_prc'] = $itemSub->name_prc;
                    $arraySubprocess["link"] = $itemSub->link_prc;
                    $arraySubprocess["submenu"] = false;
                    array_push($arrayObjectSubprocess, $arraySubprocess);
                }
            }
            return $arrayObjectSubprocess;
        } elseif (count($subprocessAux) == 1) {
            $auxProcess=$this->readOnly->getOne($serialPrc);
            $arraySubprocess['type_prc'] = 'SECUNDARY';
            $arraySubprocess['serial_prc'] = $serialPrc;
            $arraySubprocess['name_prc'] = $auxProcess->name_prc;
            $arraySubprocess["link"] = $auxProcess->link_prc;
            $arraySubprocess["submenu"] = false;
            array_push($arrayObjectSubprocess, $arraySubprocess);
            return $arrayObjectSubprocess;
        } else {
            return false;
        }
    }

    /**
     * Metodo recursivo para revisar lista de procesos
     * @since   2023-07-14
     * @author  Diego Navarrete <donvarrete@rutatec.com>
     */

}
